/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.terraforged.engine.settings.ClimateSettings;
import com.terraforged.engine.world.biome.TempCategory;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.noise.util.NoiseUtil;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeHelper {
    private static final String[] COLD_KEYWORDS = new String[]{"cold", "frozen", "ice", "chill", "tundra", "taiga", "arctic"};
    private static final String[] WARM_KEYWORDS = new String[]{"hot", "warm", "tropic", "desert", "savanna", "jungle"};

    public static TempCategory getTempCategory(Biome biome, TFBiomeContext context) {
        if (biome.func_201856_r() == Biome.Category.OCEAN) {
            return BiomeHelper.tempFromName(context.biomes.getName(biome));
        }
        if (biome.func_201856_r() == Biome.Category.BEACH) {
            float temp = biome.func_242445_k();
            if (temp <= 0.4f) {
                return TempCategory.COLD;
            }
            if ((double)temp >= 1.0) {
                return TempCategory.WARM;
            }
            return BiomeHelper.tempFromName(context.biomes.getName(biome));
        }
        float temp = biome.func_242445_k();
        if (temp <= 0.3f) {
            return TempCategory.COLD;
        }
        if ((double)temp > 0.8) {
            return TempCategory.WARM;
        }
        return BiomeHelper.tempFromName(context.biomes.getName(biome));
    }

    public static TempCategory tempFromName(String name) {
        if (BiomeHelper.containsKeyword(name, COLD_KEYWORDS)) {
            return TempCategory.COLD;
        }
        if (BiomeHelper.containsKeyword(name, WARM_KEYWORDS)) {
            return TempCategory.WARM;
        }
        return TempCategory.MEDIUM;
    }

    public static boolean containsKeyword(String name, String[] keywords) {
        for (String keyword : keywords) {
            if (!name.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static float getBiomeSizeSearchModifier(ClimateSettings settings) {
        float defaultSize = 225.0f;
        float scale = (float)settings.biomeShape.biomeSize / defaultSize;
        return NoiseUtil.clamp(scale * 0.75f, 0.0f, 1.25f);
    }

    public static TempCategory getMountainCategory(Biome biome) {
        if (BiomeHelper.getDefaultTemperature(biome) <= 0.25f) {
            return TempCategory.COLD;
        }
        if (BiomeHelper.getDefaultTemperature(biome) >= 0.75f) {
            return TempCategory.WARM;
        }
        return TempCategory.MEDIUM;
    }

    public static float getDefaultTemperature(Biome biome) {
        return biome.func_242445_k();
    }

    public static ISurfaceBuilderConfig getSurface(Biome biome) {
        if (biome != null && biome.func_242440_e() != null && biome.func_242440_e().func_242502_e() != null) {
            return biome.func_242440_e().func_242502_e();
        }
        return SurfaceBuilder.field_215428_y;
    }

    public static ConfiguredSurfaceBuilder<?> getSurfaceBuilder(Biome biome) {
        if (biome != null && biome.func_242440_e() != null && biome.func_242440_e().func_242500_d() != null) {
            return (ConfiguredSurfaceBuilder)biome.func_242440_e().func_242500_d().get();
        }
        return SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v);
    }

    public static BiomeGenerationSettings getGenSettings(Biome biome) {
        return biome.func_242440_e();
    }

    public static boolean isOverworldBiome(Biome biome, TFBiomeContext context) {
        return BiomeHelper.isOverworldBiome(context.biomes.getKey(biome));
    }

    public static boolean isOverworldBiome(@Nullable RegistryKey<Biome> key) {
        if (key == null) {
            return false;
        }
        ResourceLocation name = key.func_240901_a_();
        if (name.func_110624_b().equals("terraforged")) {
            return true;
        }
        return BiomeDictionary.getTypes(key).contains(BiomeDictionary.Type.OVERWORLD);
    }
}

